
function AISMN_Heal::OnEnter(%this, %obj)
{
   %object = GetThisObject(%obj);
   %object.startHealing();
}

function AISMN_Heal::OnExit(%this, %obj)
{
}

function AISMN_Heal::Update(%this, %obj)
{
   %object = GetThisObject(%obj);
   if(%object.isFullyHealed())
   {
      ReturnValue(%obj, 0);
   }
   else
   {
      ReturnValue(%obj, -1);
   }
}



function AISMN_HealStop::OnEnter(%this, %obj)
{
   %object = GetThisObject(%obj);
   %object.playThread(0, "getup");
}

function AISMN_HealStop::OnExit(%this, %obj)
{
   %object = GetThisObject(%obj);
   %object.stopHealing();
   schedule(1, 0, "SetUpAttackable", %obj, %object);
}

function AISMN_HealStop::Update(%this, %obj)
{
   if(TimeInNode(%obj) > 1.5)
   {
      ReturnValue(%obj, 0);
   }
   else
   {
      ReturnValue(%obj, -1);
   }
}



function SetUpAttackable(%data, %object)
{
   IsAttackable(%object, true);
   %attacker = %data.getThreatEnemy();
   if (%attacker && IsAttackable(%attacker) &&
      !%data.isAttacking() && IsAttackable(%object))
   {
      %data.performAction("attack", %attacker);
   }
   
   %data.stopReaction();
}
